<?php

/**
 * This is the model class for table "SzkolenieOdpowiedziEgzamin".
 *
 * The followings are the available columns in table 'SzkolenieOdpowiedziEgzamin':
 * @property double $id
 * @property double $idPytania
 * @property string $tresc
 */
class SzkolenieOdpowiedziEgzamin extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SzkolenieOdpowiedziEgzamin the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'SzkolenieOdpowiedziEgzamin';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idPytania', 'numerical'),
			array('tresc', 'length', 'max'=>2000),

			array('id, idPytania, tresc', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'idPytania0'=>array(self::BELONGS_TO, 'SzkoleniePytaniaEgzamin', 'idPytania'),
			'odpowiedzi'=>array(self::HAS_ONE, 'SzkolenieOdpowiedziFirmy', 'id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('SzkolenieOdpowiedziEgzamin', 'id'),
			'idPytania'=>Yii::t('SzkolenieOdpowiedziEgzamin', 'idPytania'),
			'tresc'=>Yii::t('SzkolenieOdpowiedziEgzamin', 'tresc'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idPytania', $this->idPytania);
		$criteria->compare('tresc', $this->tresc, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}